/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.db;

import java.awt.event.ActionEvent;
import jclass.cell.CellEditor;
import jclass.cell.CellRenderer;
import jclass.cell.editors.BigDecimalCellEditor;
import jclass.cell.editors.ByteCellEditor;
import jclass.cell.editors.CheckboxCellEditor;
import jclass.cell.editors.DateCellEditor;
import jclass.cell.editors.DoubleCellEditor;
import jclass.cell.editors.FloatCellEditor;
import jclass.cell.editors.IntegerCellEditor;
import jclass.cell.editors.LongCellEditor;
import jclass.cell.editors.ShortCellEditor;
import jclass.cell.editors.SqlTimeCellEditor;
import jclass.cell.editors.SqlTimestampCellEditor;
import jclass.cell.editors.StringCellEditor;
import jclass.cell.renderers.CheckboxCellRenderer;
import jclass.cell.renderers.RawImageCellRenderer;
import jclass.datasource.DataModel;
import jclass.datasource.MetaDataModel;
import jclass.field.cell.DateRendererEditor;
import jclass.field.cell.DoubleRendererEditor;
import jclass.field.cell.IntegerRendererEditor;
import jclass.table3.JCCellPosition;
import jclass.table3.JCCellRange;
import jclass.table3.LiveTable;
import jclass.table3.LocaleBundle;
import jclass.table3.TableData;
import jclass.table3.TableDataSupport;
import jclass.table3.TablePopupMenu;
import jclass.table3.VectorDataSource;
import jclass.table3.db.DataBeanSource;

public class DataTable
extends LiveTable {
    protected boolean useDatasourceEditable = true;
    private boolean isTraversing = false;
    public static final String[] commands = new String[]{LocaleBundle.string("Insert Record"), LocaleBundle.string("Delete Record(s)"), LocaleBundle.string("Refresh Record(s)"), LocaleBundle.string("Refresh All"), LocaleBundle.string("Requery Record and Details"), LocaleBundle.string("Requery All"), LocaleBundle.string("Save Record(s)"), LocaleBundle.string("Save All")};

    protected DataTable() {
        this.setAlignment(-998, -1, 4);
        this.setSelectionPolicy(2);
        this.setSelectIncludeLabels(false);
        this.setPopupMenuEnabled(true);
        this.updatePopupMenu();
    }

    protected TablePopupMenu createPopupMenu() {
        TablePopupMenu tablePopupMenu = super.createPopupMenu();
        tablePopupMenu.insertSeparator(tablePopupMenu.getItemCount());
        int n = 0;
        while (n < commands.length) {
            tablePopupMenu.addItem(commands[n], this);
            ++n;
        }
        return tablePopupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals(commands[0])) {
            this.insert();
            return;
        }
        if (string.equals(commands[1])) {
            this.delete();
            return;
        }
        if (string.equals(commands[2])) {
            this.cancelRows();
            return;
        }
        if (string.equals(commands[3])) {
            this.cancelAll();
            return;
        }
        if (string.equals(commands[4])) {
            this.requeryRows();
            return;
        }
        if (string.equals(commands[5])) {
            this.requeryAll();
            return;
        }
        if (string.equals(commands[6])) {
            this.commitRows();
            return;
        }
        if (string.equals(commands[7])) {
            this.commitAll();
        }
    }

    public void setDataSource(TableData tableData) {
        super.setDataSource(tableData);
        this.updatePopupMenu();
    }

    public void setDataSource(DataModel dataModel) {
        this.initDataBinding(new DataBeanSource(this, dataModel));
    }

    public void setDataSource(DataModel dataModel, MetaDataModel metaDataModel) {
        this.initDataBinding(new DataBeanSource(this, dataModel, metaDataModel));
    }

    protected void setDataSource(String string) {
        this.initDataBinding(new DataBeanSource(this, string));
    }

    protected void setDataSource(DataModel dataModel, String string) {
        this.initDataBinding(new DataBeanSource(this, dataModel, string));
    }

    protected void initDataBinding(DataBeanSource dataBeanSource) {
        if (dataBeanSource == null || !dataBeanSource.dataBinding.isEnabled()) {
            return;
        }
        TableData tableData = this.getDataSource();
        if (tableData != null && tableData instanceof TableDataSupport) {
            ((TableDataSupport)tableData).dispose();
        }
        this.setCellRenderer(-997, -997, null);
        this.setDataSource(dataBeanSource);
        this.updateEditors();
    }

    protected String getDataBinding() {
        DataBeanSource dataBeanSource = this.getDataBeanSource();
        if (dataBeanSource != null) {
            return dataBeanSource.getDataBinding();
        }
        return "";
    }

    protected boolean setDataBinding(DataModel dataModel, MetaDataModel metaDataModel) {
        DataBeanSource dataBeanSource = this.getDataBeanSource();
        if (dataBeanSource != null) {
            dataBeanSource.dataBinding.setDataBinding(dataModel, metaDataModel);
            return true;
        }
        return false;
    }

    void updatePopupMenu() {
        if (this.popupMenu == null) {
            return;
        }
        DataBeanSource dataBeanSource = this.getDataBeanSource();
        boolean bl = dataBeanSource != null && dataBeanSource.dataBinding.isEnabled();
        boolean bl2 = bl && dataBeanSource.dataBinding.isDataAvailable();
        boolean bl3 = bl2 && dataBeanSource.dataBinding.getNumRows() > 0 && this.getSelectedRange(0, new JCCellRange());
        this.popupMenu.enableMenuItem("Insert Record", bl2);
        this.popupMenu.enableMenuItem("Delete Record(s)", bl3);
        this.popupMenu.enableMenuItem("Refresh Record(s)", bl3);
        this.popupMenu.enableMenuItem("Refresh All", bl);
        this.popupMenu.enableMenuItem("Requery Record and Details", bl3);
        this.popupMenu.enableMenuItem("Requery All", bl);
        this.popupMenu.enableMenuItem("Save Record(s)", bl3);
        this.popupMenu.enableMenuItem("Save All", bl);
    }

    protected void tableChanged() {
        this.cancelEdit(true);
        this.clearSelectedCells();
        this.updatePopupMenu();
        this.updateEditors();
    }

    protected boolean beforeCurrentRowChange() {
        return this.commitEdit(true);
    }

    void setCurrentCell(int n) {
        JCCellPosition jCCellPosition = this.getCurrentCell();
        if (!this.isTraversing) {
            this.traverse(n != -1 ? n : 0, jCCellPosition != null ? jCCellPosition.column : 0, false, false);
        }
    }

    protected JCCellRange getSelection() {
        JCCellRange jCCellRange = new JCCellRange();
        if (!this.getSelectedRange(0, jCCellRange)) {
            this.showMessage("Error", "No rows selected.");
            return null;
        }
        this.clearSelectedCells();
        return jCCellRange;
    }

    protected void insert() {
        ((DataBeanSource)this.getDataSource()).dataBinding.addRow();
    }

    protected void delete() {
        JCCellRange jCCellRange = this.getSelection();
        if (jCCellRange != null) {
            this.setRepaint(false);
            ((DataBeanSource)this.getDataSource()).dataBinding.deleteRows(jCCellRange.start_row, jCCellRange.end_row - jCCellRange.start_row + 1);
            this.setRepaint(true);
        }
    }

    protected void cancelRows() {
        JCCellRange jCCellRange = this.getSelection();
        if (jCCellRange != null) {
            this.setRepaint(false);
            ((DataBeanSource)this.getDataSource()).dataBinding.cancelRows(jCCellRange.start_row, jCCellRange.end_row - jCCellRange.start_row + 1);
            this.setRepaint(true);
        }
    }

    protected void cancelAll() {
        ((DataBeanSource)this.getDataSource()).dataBinding.cancelAll();
    }

    protected void requeryRows() {
        JCCellRange jCCellRange = this.getSelection();
        if (jCCellRange != null) {
            this.setRepaint(false);
            ((DataBeanSource)this.getDataSource()).dataBinding.requeryRowsAndDetails(jCCellRange.start_row, jCCellRange.end_row - jCCellRange.start_row + 1);
            this.setRepaint(true);
        }
    }

    protected void requeryAll() {
        ((DataBeanSource)this.getDataSource()).dataBinding.requeryAll();
    }

    protected void commitRows() {
        JCCellRange jCCellRange = this.getSelection();
        if (jCCellRange != null) {
            this.setRepaint(false);
            ((DataBeanSource)this.getDataSource()).dataBinding.commitRows(jCCellRange.start_row, jCCellRange.end_row - jCCellRange.start_row + 1);
            this.setRepaint(true);
        }
    }

    protected void commitAll() {
        ((DataBeanSource)this.getDataSource()).dataBinding.commitAll();
    }

    protected boolean isTraverseAllowed(int n, int n2) {
        DataBeanSource dataBeanSource = this.getDataBeanSource();
        boolean bl = false;
        if (dataBeanSource != null) {
            this.isTraversing = true;
            bl = dataBeanSource.dataBinding.moveToRow(n);
            this.isTraversing = false;
        }
        return bl;
    }

    public void afterCellSelected() {
        this.updatePopupMenu();
    }

    public void setAdvancedEditorRenderers(boolean bl) {
        super.setAdvancedEditorRenderers(bl);
        this.updateEditors();
    }

    protected DataBeanSource getDataBeanSource() {
        TableData tableData = this.getDataSource();
        if (tableData != null && tableData instanceof DataBeanSource) {
            return (DataBeanSource)tableData;
        }
        return null;
    }

    protected Object getNativeMetaData() {
        DataBeanSource dataBeanSource = this.getDataBeanSource();
        if (dataBeanSource != null) {
            return dataBeanSource.getNativeMetaData();
        }
        return null;
    }

    public void setUseDatasourceEditable(boolean bl) {
        this.useDatasourceEditable = bl;
        this.cancelEdit(true);
        this.updateEditors();
    }

    public boolean getUseDatasourceEditable() {
        return this.useDatasourceEditable;
    }

    protected void updateEditors() {
        DataBeanSource dataBeanSource = this.getDataBeanSource();
        if (dataBeanSource == null || !dataBeanSource.dataBinding.isEnabled() || !dataBeanSource.dataBinding.isDataAvailable()) {
            return;
        }
        int n = 0;
        while (n < this.getNumColumns()) {
            String string = (String)dataBeanSource.getTableColumnLabel(n);
            if (this.useDatasourceEditable) {
                this.setEditable(-998, n, dataBeanSource.dataBinding.isColumnEditable(string));
            }
            CellEditor cellEditor = null;
            CellRenderer cellRenderer = null;
            if (this.getAdvancedEditorRenderers()) {
                switch (dataBeanSource.getJavaColumnType(string)) {
                    case 0: {
                        cellEditor = new CheckboxCellEditor();
                        cellRenderer = new CheckboxCellRenderer();
                        break;
                    }
                    case 12: {
                        cellEditor = new IntegerRendererEditor();
                        break;
                    }
                    case 11: {
                        cellEditor = new IntegerRendererEditor();
                        break;
                    }
                    case 4: {
                        cellEditor = new IntegerRendererEditor();
                        break;
                    }
                    case 7: {
                        cellEditor = new LongCellEditor();
                        break;
                    }
                    case 2: {
                        cellEditor = new DoubleRendererEditor();
                        break;
                    }
                    case 3: {
                        cellEditor = new DoubleRendererEditor();
                        break;
                    }
                    case 6: {
                        cellEditor = new BigDecimalCellEditor();
                        break;
                    }
                    case 1: {
                        cellEditor = new DateRendererEditor();
                        break;
                    }
                    case 8: {
                        cellEditor = new DateRendererEditor();
                        break;
                    }
                    case 9: {
                        cellEditor = new DateRendererEditor();
                        break;
                    }
                    case 14: {
                        cellEditor = new DateRendererEditor();
                        break;
                    }
                    case 13: {
                        cellRenderer = new RawImageCellRenderer();
                        break;
                    }
                    default: {
                        cellEditor = new StringCellEditor();
                        break;
                    }
                }
            } else {
                switch (dataBeanSource.getJavaColumnType(string)) {
                    case 0: {
                        cellEditor = new CheckboxCellEditor();
                        cellRenderer = new CheckboxCellRenderer();
                        break;
                    }
                    case 12: {
                        cellEditor = new ShortCellEditor();
                        break;
                    }
                    case 11: {
                        cellEditor = new ByteCellEditor();
                        break;
                    }
                    case 4: {
                        cellEditor = new IntegerCellEditor();
                        break;
                    }
                    case 7: {
                        cellEditor = new LongCellEditor();
                        break;
                    }
                    case 2: {
                        cellEditor = new DoubleCellEditor();
                        break;
                    }
                    case 3: {
                        cellEditor = new FloatCellEditor();
                        break;
                    }
                    case 6: {
                        cellEditor = new BigDecimalCellEditor();
                        break;
                    }
                    case 1: {
                        cellEditor = new DateCellEditor();
                        break;
                    }
                    case 8: {
                        cellEditor = new SqlTimeCellEditor();
                        break;
                    }
                    case 9: {
                        cellEditor = new SqlTimestampCellEditor();
                        break;
                    }
                    case 13: {
                        cellRenderer = new RawImageCellRenderer();
                        break;
                    }
                    default: {
                        cellEditor = new StringCellEditor();
                    }
                }
            }
            if (cellEditor != null) {
                this.setCellEditor(-997, n, cellEditor);
            }
            if (cellRenderer != null) {
                this.setCellRenderer(-997, n, cellRenderer);
            }
            ++n;
        }
    }

    protected Class getColumnClass(int n) {
        DataBeanSource dataBeanSource = this.getDataBeanSource();
        if (dataBeanSource == null) {
            return null;
        }
        try {
            String string = (String)dataBeanSource.getTableColumnLabel(n);
            switch (dataBeanSource.getJavaColumnType(string)) {
                case 0: {
                    return Class.forName("java.lang.Boolean");
                }
                case 12: {
                    return Class.forName("java.lang.Short");
                }
                case 11: {
                    return Class.forName("java.lang.Byte");
                }
                case 4: {
                    return Class.forName("java.lang.Integer");
                }
                case 7: {
                    return Class.forName("java.lang.Long");
                }
                case 2: {
                    return Class.forName("java.lang.Double");
                }
                case 3: {
                    return Class.forName("java.lang.Float");
                }
                case 6: {
                    return Class.forName("java.math.BigDecimal");
                }
                case 1: {
                    return Class.forName("java.sql.Date");
                }
                case 8: {
                    return Class.forName("java.sql.Time");
                }
                case 9: {
                    return Class.forName("java.sql.Timestamp");
                }
                case 13: {
                    return null;
                }
            }
            return Class.forName("java.lang.String");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void makeDataSource() {
        VectorDataSource vectorDataSource = new VectorDataSource();
        vectorDataSource.setNumRows(this.getNumRows());
        vectorDataSource.setNumColumns(this.getNumColumns());
        int n = 0;
        while (n < vectorDataSource.getNumColumns()) {
            vectorDataSource.setColumnLabel(n, "Column: " + n);
            ++n;
        }
        int n2 = 0;
        while (n2 < vectorDataSource.getNumRows()) {
            vectorDataSource.setRowLabel(n2, "Row: " + n2);
            ++n2;
        }
        this.setDataSource(vectorDataSource);
    }
}

